
/**
La función agrega una palabra seleccionada a la línea correspondiente de respuesta del usuario, 
colocándola en el primer espacio vacío, actualiza visualmente el contenedor,
 y muestra una traducción flotante (tipo "tooltip").
 */

function addWord(lineIdx, word) {

  if (!userAnswers[lineIdx]) userAnswers[lineIdx] = [];

  const slots = document.querySelectorAll(`.word-slot[data-line="${lineIdx}"]`);



  for (let i = 0; i < slots.length; i++) {

    if (!userAnswers[lineIdx][i]) {

      userAnswers[lineIdx][i] = word;

      slots[i].textContent = word;

      slots[i].classList.remove('empty');

      slots[i].classList.add('filled');

      disableWordButton(lineIdx, word, true);

      checkCompletion(lineIdx);



      // Mostrar la palabra flotante (traducción al español)

     showFloatingTranslation(word, slots[i], lineIdx);





      break;

    }

  }

}
